/* This header file configures the HPRFGW modules based on
OS. */
/*----------------------------------------------------------------------*/
#ifndef _hprfgw_config_h
#define _hprfgw_config_h

/*----------------------------------------------------------------------*/
/* Configure the Operating system used. Supported defines are:			*/
/*			OS_NUCLEUS													*/
/*			OS_WINCE													*/
/*          OS_LINUX                                                  */
/*----------------------------------------------------------------------*/
#define OS_LINUX 1
#define DM_LINUX 1

/*----------------------------------------------------------------------*/
/*				Hardware dependent settings								*/
/*----------------------------------------------------------------------*/
/* Enable or disable internal IRQ pull up of the MC13192 chip. Nautilus 
doesn't have a pull up connected to the IRQ line at the MC13192 */
#define	MC13192_IRQ_PULLUP_ENABLE	(1)

/*----------------------------------------------------------------------*/

/*----------------------------------------------------------------------*/
/* OS depending header file include */
/*----------------------------------------------------------------------*/
#if defined (OS_WINCE)
 #include <windows.h>
 #include <ceddk.h>
 #include <winbase.h>
 #include <math.h>
 #include "hprf_winceIntfc.h"
 #include "stdlib.h" /* For rand() */
 #include <string.h>
#elif defined (OS_NUCLEUS)
 #include <nucleus.h>
 #include <net/target.h>
 #include "nutypedefs.h"
 #include <string.h>
 #include <mathf.h>
 #include "stdlib.h" /* For rand() */
#elif defined (OS_LINUX)
/* #include <linux/types.h> */
 #include <linux/random.h>
 #include <linux/string.h>
 #include <linux/kernel.h>
 #include <linux/printk.h>

/* #include "hprfgw_rfEmbeddedTypes.h" */
#include "../../CrestCore/inc/interface/dm_os.h"
#include "../../CrestCore/inc/interface/dm_console.h"
#include "../../CrestCore/inc/interface/dm_gpio.h"
#include "../../CrestCore/inc/interface/dm_spi.h"
#include "../../CrestCore/inc/interface/dm_errors.h"
#include "../../CrestCoreLinuxKernel/Src/dm_os_linux.h"

typedef UINT32 DM_RESOURCE_HANDLE;
#define VERBOSE_PRINTF 0

 #define ERROR (-1)
int rand(void);
void srand(unsigned int seed);

#else
 #error "Operating System is not configured in hprfgw_config.h"
#endif
#if defined(OS_NUCLEUS) || defined(OS_WINCE)
 #include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
#endif

/*----------------------------------------------------------------------*/
/*   Any defines related to OS										    */
/*----------------------------------------------------------------------*/
/*  Common Defines for all OS */

#define PROFILE_CODE 0
#define HPRF_DEBUG(X)
#define HPRF_QUEUE_DEBUG(X)


#if defined (OS_WINCE)

 #define SUCCESS					0
 #define FAILURE					-1

 #define RF_TASKS_BASE_PRIORITY	    70  //50 //20 //100
 #define RF_INTR_THREAD_PRIORITY    50  //20 //5  //20
 #define RF_TIMER_THREAD_PRIORITY   60  //30 //10 //30

 // Other defines
 #define powf(a, b)	(float)pow((float)a, (float)b)
 #define OS_Sleep(time)		Sleep(((time)*10))
 #define OS_RetrieveClock()	GetTickCount()


 typedef unsigned long		UNSIGNED;
 typedef int				STATUS;

 #define TICKS_PER_SECOND	100
 #define OS_NO_SUSPEND		0
 #define OS_SUSPEND			INFINITE

 // Debug flags for RETAIL and DEBUG MSGS (not used currently)
#define HPRF_DEBUG_INTR		0		/* Retail messages during interrupt thread */
#define HPRF_DEBUG_GENERIC  1

// Unaligned keyword for Windows CE.
#define HPRF_UNALIGNED      UNALIGNED

#elif defined (OS_NUCLEUS)

 #define SUCCESS			NU_SUCCESS
 #define FAILURE			-1

 #define OS_Sleep(time)		NU_Sleep(time)
 #define OS_RetrieveClock()	NU_Retrieve_Clock()

 // We don't need the Unaligned for Nucleus
 #define HPRF_UNALIGNED

#if PROFILE_CODE
 extern unsigned long TMD_System_Clock;
 #pragma info "This should be changed if the processor changes!!!"
 #define NUCLEUS_TIMER_VAL (volatile unsigned short *)(0x40000000 + 0x150004)
 #define CURRENT_TIME_STAMP \
         (((TMD_System_Clock & 0x0000FFFF) << 16) | (unsigned short)((*NUCLEUS_TIMER_VAL) & 0xFFFF))
#endif

 /* Calculate the priority based on the platform. Some platforms, ie Windows, use
  * a lower number to mean higher priority. Linux uses a higher number to mean higher
  * priority for realtime tasks. Positive MOD means higher priority relative to BASE. */
#define RF_TASK_PRIORITY(BASE, MOD) ((BASE) - (MOD))

#elif defined (OS_LINUX)
 //TODO: Fix code to use HwGetMsec directly.
 #define OS_RetrieveClock()	HwGetMsec()
 #define OS_NO_SUSPEND		0
 #define OS_SUSPEND			OS_WAIT_FOREVER
 typedef int				STATUS;
 typedef void*              HANDLE;

#define RF_TASKS_BASE_PRIORITY	  60
#define RF_INTR_THREAD_PRIORITY   80
#define RF_TIMER_THREAD_PRIORITY  70
/* Calculate the priority based on the platform. Some platforms, ie Windows, use
 * a lower number to mean higher priority. Linux uses a higher number to mean higher
 * priority for realtime tasks. Positive MOD means higher priority relative to BASE. */
#define RF_TASK_PRIORITY(BASE, MOD) ((BASE) + (MOD))

/* Always use ansi... */
#define HPRF_PRINT(FSTR) \
	pr_info(FSTR)

 #define TEXT(text) text
#define RETAILMSG(CONDITION, ...) \
do {\
	int ret__ = 0; \
	if(CONDITION) { \
		ret__ = printk __VA_ARGS__; \
	} \
} while(0)

#define HPRF_UNALIGNED

/* #define SUCCESS					0 */
/* #define FAILURE				   -1 */

#define CURRENT_TIME_STAMP      HwGetMsec()

#else
 #error "OS not defined"
#endif

/********************************************************************/
/*                    Endianness settings							*/
/********************************************************************/

// Define Endianness
#if defined (OS_NUCLEUS)
 #define HPRF_BIG_ENDIAN			// Processor uses Big endian
 //#define HPRF_LITTLE_ENDIAN		// Processor uses Little endian
#elif defined (OS_WINCE)
 //#define HPRF_BIG_ENDIAN			// Processor uses Big endian
 #define HPRF_LITTLE_ENDIAN			// Processor uses Little endian
#elif defined (OS_LINUX)
 #define HPRF_LITTLE_ENDIAN (1)
#endif

#if defined (HPRF_BIG_ENDIAN)
 #define HPRF_HTONS(a)
 #define HPRF_NTOHS(a)
 #define HPRF_HTONL(a)
 #define HPRF_NTOHL(a)

#elif defined (HPRF_LITTLE_ENDIAN)
 #define HPRF_HTONS(a) (a = (((UINT16)a & 0xFF) << 8) | (((UINT16)a & 0xFF00) >> 8))
 #define HPRF_NTOHS(a) (a = (((UINT16)a & 0xFF) << 8) | (((UINT16)a & 0xFF00) >> 8))
 #define HPRF_HTONL(a) (a = (a >> 24) | ((a & 0xff0000) >> 8) | ((a & 0xff00) << 8) | (a << 24))
 #define HPRF_NTOHL(a) (a = (a >> 24) | ((a & 0xff0000) >> 8) | ((a & 0xff00) << 8) | (a << 24))

#endif

/********************************************************************/
/********************************************************************/

/*----------------------------------------------------------------------*/
/*----------------------------------------------------------------------*/

#endif /*_hprfgw_config_h */
